*** COS 2022 11, last update 2023 03  
           
program define dq_met_dtq, rclass  
syntax  , [ indent(int 0)]  
local indent=`indent'+5  
local adoname "dq_met_dtq"  
local text_i "di as text _n "  					  
*import excel "D:\Daten\Daten andere\Eurocrine 2022\meta_data1 2022-10-18.xlsx", sheet("meta_data1 2022-10-18 ") firstrow  clear  
foreach var in var_name data_type limit_hard_low limit_hard_up limit_soft_low limit_soft_up key_datetime missinglist jumplist key_observer key_devicevarlabel {  
	capture confirm variable `var'  
	if _rc==0 drop `var'  
}          
capture confirm var VAR_NAMES  
if _rc==0 {  
	rename VAR_NAMES  var_name  
}	         
capture confirm var KEY_DATETIME  
if _rc==0 {  
	rename KEY_DATETIME  key_datetime  
}	         
capture confirm var KEY_OBSERVER  
if _rc==0 {  
	rename KEY_OBSERVER  key_observer  
}	         
capture confirm var KEY_DEVICE  
if _rc==0 {  
	rename KEY_DEVICE  key_device  
}	         
capture confirm var LABEL  
if _rc==0 {  
	rename LABEL  varlabel  
}	         
 				      
capture confirm var DATA_TYPE  
if _rc==0 {  
	rename DATA_TYPE  data_type  
}	         
 		        
capture drop missinglist  
capture confirm var MISSING_LIST  
if _rc==0 {  
	rename MISSING_LIST  missinglist  
	qui replace missinglist =subinstr(missinglist,"|"," ",.)					  
}	         
capture drop jumplist  
capture confirm var JUMP_LIST  
if _rc==0 {  
	rename JUMP_LIST  jumplist  
	qui replace jumplist =subinstr(jumplist,"|"," ",.)					  
}	         
capture drop value_label  
capture confirm var VALUE_LABELS  
if _rc==0 {  
	rename VALUE_LABELS  value_label  
	local vallabel = subinstr(`"`vallabel'"', "=", `" ""', .)					  
	local vallabel = subinstr(`"`vallabel'"', " |", `"""', .)					  
}          
									  
*** Limits HARD_LIMITS SOFT_LIMITS  
local HARD_LIMITS "limit_hard"  
local SOFT_LIMITS "limit_soft"  
capture drop limit_*  
foreach var in HARD_LIMITS SOFT_LIMITS {  
	capture confirm var `var'  
	if _rc==0 {  
		tempvar interval  
		qui gen `interval' =subinstr(`var'," ","",.)					  
		qui replace `interval' =subinstr(`interval',`"""',"",.)			  
		         
		qui replace `interval'="." if trim(`var')=="NA"					  
		         
		qui replace `interval'=subinstr(`interval',"[","<",1)			  
		qui replace `interval'=subinstr(`interval',"(","<=",1)			  
		*tab `interval'  
		*Generate Breakpoints  
		tempvar splitat  
		generate `splitat' = strpos(`interval',";")  
		         
		tempvar lastchar  
		qui gen str1 `lastchar' = ""  
		qui replace `lastchar'=substr(`interval',-1,.) if `splitat'>0	  
				       
		qui gen str1 ``var''_low = ""  
		qui gen str1 ``var''_up = ""  
		qui replace ``var''_low = usubstr(`interval',1,`splitat' - 1) if `splitat'>0  
		qui replace ``var''_up = usubstr(`interval',`splitat' + 1,.) if `splitat'>0  
		qui replace ``var''_up=`lastchar' + subinstr(``var''_up,`lastchar',"",1 ) if `splitat'>0  
		qui replace ``var''_up=subinstr(``var''_up,")",">=",1)			  
		qui replace ``var''_up=subinstr(``var''_up,"]",">",1)			  
		         
		qui replace ``var''_up="."  if strpos(``var''_up,"Inf")>0			  
		qui replace ``var''_low="." if strpos(``var''_low,"Inf")>0			  
		         
		         
		di       
		di "The following adapted limits occurred:"  
		*list var_name `var' ``var''_low ``var''_up if `splitat'>0  
		         
		qui drop `interval' `splitat' `lastchar'  
	}	        
}          
*moss ``var'', match("([>]+)") regex suffix(_lower)  
*moss ``var'', match("([<]+)") regex suffix(_upper)  
end        
